﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Buy_Buy : System.Web.UI.MasterPage
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    private String GetPaypalFormHtml(NameValueCollection formData)
    {
        StringBuilder formHtml = new StringBuilder();
        formHtml.Append("<form id=\"paypal\" name=\"paypal\" target=\"_blank\" action=\"https://www.paypal.com/cgi-bin/webscr\" method=\"post\">");
        foreach (string name in formData)
        {
            string value = formData[name];
            formHtml.AppendFormat("<input type=\"hidden\" name=\"{0}\" value=\"{1}\" />", name, value);
        }
        formHtml.Append("<input type=\"image\" name=\"submit\" src=\"https://www.paypal.com/en_US/i/scr/pixel.gif\" alt=\"\" border=\"0\" width=\"1\" height=\"1\" />");
        formHtml.Append("</form>");

        return String.Format(formHtml.ToString());
    }
    private String GetPayPalJavaScript(String formId)
    {
        StringBuilder javaScript = new StringBuilder();
        javaScript.Append("<script type=\"text/javascript\">");
        javaScript.Append("var paypalForm = document.forms.namedItem('{0}');");
        javaScript.Append("paypalForm.submit();");
        javaScript.Append("</script>");
        return String.Format(javaScript.ToString(), formId);
    }

    protected void btnView_ServerClick(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("display", "1");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit
    }
}
