﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Buy_Envelopes_E1450 : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    private String GetPaypalFormHtml(NameValueCollection formData)
    {
        StringBuilder formHtml = new StringBuilder();
        formHtml.Append("<form id=\"paypal\" name=\"paypal\" target=\"_blank\" action=\"https://www.paypal.com/cgi-bin/webscr\" method=\"post\">");
        foreach (string name in formData)
        {
            string value = formData[name];
            formHtml.AppendFormat("<input type=\"hidden\" name=\"{0}\" value=\"{1}\" />", name, value);
        }
        formHtml.Append("<input type=\"image\" name=\"submit\" src=\"https://www.paypal.com/en_US/i/scr/pixel.gif\" alt=\"\" border=\"0\" width=\"1\" height=\"1\" />");
        formHtml.Append("</form>");

        return String.Format(formHtml.ToString());
    }
    private String GetPayPalJavaScript(String formId)
    {
        StringBuilder javaScript = new StringBuilder();
        javaScript.Append("<script type=\"text/javascript\">");
        javaScript.Append("var paypalForm = document.forms.namedItem('{0}');");
        javaScript.Append("paypalForm.submit();");
        javaScript.Append("</script>");
        return String.Format(javaScript.ToString(), formId);
    }

    protected void btnAdd_Click(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("lc", "US");
        formData.Add("item_name", "CMS-1450 Jumbo 9 1/2\" Envelopes Left Window - With Wording for Careful Handling");
        formData.Add("item_number", "envCMS_21");
        formData.Add("amount", Session["envCMS_21_price"].ToString());
        formData.Add("currency_code", "USD");
        formData.Add("button_subtype", "products");
        formData.Add("tax_rate", Session["envCMS_21_tax"].ToString());
        formData.Add("shipping", Session["envCMS_21_shipping"].ToString());
        formData.Add("add", "1");
        formData.Add("bn", "PP-ShopCartBF:add_to_cart.png:NonHostedGuest");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit

    }
    protected void btnAdd2_Click(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("lc", "US");
        formData.Add("item_name", "CMS-1450 Jumbo 9 1/2\" Envelopes Left Window - With Wording for Careful Handling");
        formData.Add("item_number", "envCMS_22");
        formData.Add("amount", Session["envCMS_22_price"].ToString());
        formData.Add("currency_code", "USD");
        formData.Add("button_subtype", "products");
        formData.Add("tax_rate", Session["envCMS_22_tax"].ToString());
        formData.Add("shipping", Session["envCMS_22_shipping"].ToString());
        formData.Add("add", "1");
        formData.Add("bn", "PP-ShopCartBF:add_to_cart.png:NonHostedGuest");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit

    }

    protected void btnAdd3_Click(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("lc", "US");
        formData.Add("item_name", "CMS-1450 Jumbo 9 1/2\" Envelopes Left Window - With Wording for Careful Handling");
        formData.Add("item_number", "envCMS_23");
        formData.Add("amount", Session["envCMS_23_price"].ToString());
        formData.Add("currency_code", "USD");
        formData.Add("button_subtype", "products");
        formData.Add("tax_rate", Session["envCMS_23_tax"].ToString());
        formData.Add("shipping", Session["envCMS_23_shipping"].ToString());
        formData.Add("add", "1");
        formData.Add("bn", "PP-ShopCartBF:add_to_cart.png:NonHostedGuest");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit

    }
    protected void btnAdd4_Click(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("lc", "US");
        formData.Add("item_name", "CMS-1450 Jumbo 9 1/2\" Envelopes Left Window - With Wording for Careful Handling");
        formData.Add("item_number", "envCMS_24");
        formData.Add("amount", Session["envCMS_24_price"].ToString());
        formData.Add("currency_code", "USD");
        formData.Add("button_subtype", "products");
        formData.Add("tax_rate", Session["envCMS_24_tax"].ToString());
        formData.Add("shipping", Session["envCMS_24_shipping"].ToString());
        formData.Add("add", "1");
        formData.Add("bn", "PP-ShopCartBF:add_to_cart.png:NonHostedGuest");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit

    }
}