﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Buy_Software_DentOffice : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    private String GetPaypalFormHtml(NameValueCollection formData)
    {
        StringBuilder formHtml = new StringBuilder();
        formHtml.Append("<form id=\"paypal\" name=\"paypal\" target=\"_blank\" action=\"https://www.paypal.com/cgi-bin/webscr\" method=\"post\">");
        foreach (string name in formData)
        {
            string value = formData[name];
            formHtml.AppendFormat("<input type=\"hidden\" name=\"{0}\" value=\"{1}\" />", name, value);
        }
        formHtml.Append("<input type=\"image\" name=\"submit\" src=\"https://www.paypal.com/en_US/i/scr/pixel.gif\" alt=\"\" border=\"0\" width=\"1\" height=\"1\" />");
        formHtml.Append("</form>");

        return String.Format(formHtml.ToString());
    }
    private String GetPayPalJavaScript(String formId)
    {
        StringBuilder javaScript = new StringBuilder();
        javaScript.Append("<script type=\"text/javascript\">");
        javaScript.Append("var paypalForm = document.forms.namedItem('{0}');");
        javaScript.Append("paypalForm.submit();");
        javaScript.Append("</script>");
        return String.Format(javaScript.ToString(), formId);
    }

    protected void btnAdd_Click(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("lc", "US");
        formData.Add("item_name", "DentOffice: Single-User ");
        formData.Add("item_number", "DentOffice_01");
        formData.Add("amount", Session["DentOffice_Software_Single_User_price"].ToString());
        formData.Add("currency_code", "USD");
        formData.Add("button_subtype", "products");
        formData.Add("tax_rate", Session["DentOffice_Tax"].ToString());
        formData.Add("shipping", Session["DentOffice_Shipping"].ToString());
        formData.Add("add", "1");
        formData.Add("bn", "PP-ShopCartBF:add_to_cart.png:NonHostedGuest");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit

    }

    protected void btnAdd3_Click(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("lc", "US");
        formData.Add("item_name", "DentOffice: 5-Station Multi-user ");
        formData.Add("item_number", "DentOffice_03");
        formData.Add("amount", Session["DentOffice_Software_5_User_Price"].ToString());
        formData.Add("currency_code", "USD");
        formData.Add("button_subtype", "products");
        formData.Add("tax_rate", Session["DentOffice_Tax"].ToString());
        formData.Add("shipping", Session["DentOffice_Shipping"].ToString());
        formData.Add("add", "1");
        formData.Add("bn", "PP-ShopCartBF:add_to_cart.png:NonHostedGuest");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit

    }
    protected void btnAdd6_Click(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("lc", "US");
        formData.Add("item_name", "DentOffice: 10-Station Multi-user ");
        formData.Add("item_number", "DentOffice_06");
        formData.Add("amount", Session["DentOffice_Software_10_User_Price"].ToString());
        formData.Add("currency_code", "USD");
        formData.Add("button_subtype", "products");
        formData.Add("tax_rate", Session["DentOffice_Tax"].ToString());
        formData.Add("shipping", Session["DentOffice_Shipping"].ToString());
        formData.Add("add", "1");
        formData.Add("bn", "PP-ShopCartBF:add_to_cart.png:NonHostedGuest");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit

    }

    protected void btnAdd22_Click(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("lc", "US");
        formData.Add("item_name", "DentOffice: INTRODUCTORY: Six (6) hours of one-on-one training sessions @ $120/hour");
        formData.Add("item_number", "DentOffice_22");
        formData.Add("amount", Session["DentOffice_Training_Intro"].ToString());
        formData.Add("currency_code", "USD");
        formData.Add("button_subtype", "products");
        formData.Add("tax_rate", Session["DentOffice_Tax"].ToString());
        formData.Add("shipping", Session["DentOffice_Shipping"].ToString());
        formData.Add("add", "1");
        formData.Add("bn", "PP-ShopCartBF:add_to_cart.png:NonHostedGuest");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit

    }
    protected void btnAdd23_Click(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("lc", "US");
        formData.Add("item_name", "DentOffice: INTERMEDIATE: 8 hours of one-on-one training sessions @ $120/hour LESS 5% OFF (the advanced training includes the introductory sessions)");
        formData.Add("item_number", "DentOffice_23");
        formData.Add("amount", Session["DentOffice_Training_Intermediate"].ToString());
        formData.Add("currency_code", "USD");
        formData.Add("button_subtype", "products");
        formData.Add("tax_rate", Session["DentOffice_Tax"].ToString());
        formData.Add("shipping", Session["DentOffice_Shipping"].ToString());
        formData.Add("add", "1");
        formData.Add("bn", "PP-ShopCartBF:add_to_cart.png:NonHostedGuest");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit

    }
    protected void btnAdd24_Click(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("lc", "US");
        formData.Add("item_name", "DentOffice: ADVANCED: 12 hours of one-on-one training sessions @ $120/hour LESS 10% OFF. (the comprehensive training includes the introductory & advanced training sessions)");
        formData.Add("item_number", "DentOffice_24");
        formData.Add("amount", Session["DentOffice_Training_Advanced_Training"].ToString());
        formData.Add("currency_code", "USD");
        formData.Add("button_subtype", "products");
        formData.Add("tax_rate", Session["DentOffice_Tax"].ToString());
        formData.Add("shipping", Session["DentOffice_Shipping"].ToString());
        formData.Add("add", "1");
        formData.Add("bn", "PP-ShopCartBF:add_to_cart.png:NonHostedGuest");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit

    }
    protected void btnAdd25_Click(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("lc", "US");
        formData.Add("item_name", "DentOffice: ON-SITE TRAINING: 3-Day comprehensive training at your location anywhere in the USA");
        formData.Add("item_number", "DentOffice_25");
        formData.Add("amount", Session["DentOffice_Training_On_Site"].ToString());
        formData.Add("currency_code", "USD");
        formData.Add("button_subtype", "products");
        formData.Add("tax_rate", Session["DentOffice_Tax"].ToString());
        formData.Add("shipping", Session["DentOffice_Shipping"].ToString());
        formData.Add("add", "1");
        formData.Add("bn", "PP-ShopCartBF:add_to_cart.png:NonHostedGuest");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit

    }
    protected void btnAdd26_Click(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("lc", "US");
        formData.Add("item_name", "DentOffice: Per Incident Support (up to 30 minutes)");
        formData.Add("item_number", "DentOffice_26");
        formData.Add("amount", Session["DentOffice_Support_Per_Incident_Users_Single_Multi"].ToString());
        formData.Add("currency_code", "USD");
        formData.Add("button_subtype", "products");
        formData.Add("tax_rate", Session["DentOffice_Tax"].ToString());
        formData.Add("shipping", Session["DentOffice_Shipping"].ToString());
        formData.Add("add", "1");
        formData.Add("bn", "PP-ShopCartBF:add_to_cart.png:NonHostedGuest");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit

    }
    protected void btnAdd28_Click(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("lc", "US");
        formData.Add("item_name", "DentOffice: Annual Support (up to 25 Incidents/yr. Each incident up to 30 minutes)");
        formData.Add("item_number", "DentOffice_28");
        formData.Add("amount", Session["DentOffice_Support_Annual_Users_Single_To_8"].ToString());
        formData.Add("currency_code", "USD");
        formData.Add("button_subtype", "products");
        formData.Add("tax_rate", Session["DentOffice_Tax"].ToString());
        formData.Add("shipping", Session["DentOffice_Shipping"].ToString());
        formData.Add("add", "1");
        formData.Add("bn", "PP-ShopCartBF:add_to_cart.png:NonHostedGuest");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit

    }
    protected void btnAdd32_Click(object sender, EventArgs e)
    {
        NameValueCollection formData = new NameValueCollection();
        formData.Add("cmd", "_cart");
        formData.Add("business", Session["paypalEmail"].ToString());
        formData.Add("lc", "US");
        formData.Add("item_name", "DentOffice: Annual Support for HL-7 Module (Up to 15 Incidents per Year)");
        formData.Add("item_number", "DentOffice_32");
        formData.Add("amount", Session["DentOffice_Support_Annual_SydaLINK_HL_7"].ToString());
        formData.Add("currency_code", "USD");
        formData.Add("button_subtype", "products");
        formData.Add("tax_rate", Session["DentOffice_Tax"].ToString());
        formData.Add("shipping", Session["DentOffice_Shipping"].ToString());
        formData.Add("add", "1");
        formData.Add("bn", "PP-ShopCartBF:add_to_cart.png:NonHostedGuest");

        PayPalFormLiteral.Text = GetPaypalFormHtml(formData);
        PayPalJavaScriptLiteral.Text = GetPayPalJavaScript("paypal"); // this will call submit

    }
}