﻿<%@ Page Title="EMR Software" Language="C#" MasterPageFile="~/Buy/Buy.master" AutoEventWireup="true" CodeFile="EMR.aspx.cs" Inherits="Buy_Software_EMR" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" Runat="Server">
    <h3><b>EMR</b> &nbsp; <small>Please <a href="/Contact-Us">Contact Us</a> for EMR sales</small></h3>

    <div class="row">
        <div class="col-md-8">
            <h3 class="text-primary">Practice-Friendly Software Design...</h3>
            <p>Our EMR Software's design concentrates frequently accessed patient data in just a few screens:</p>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <h4 class="text-primary">Practice View</h4>
            <p>EMR Software Practice View screen provides an up-to-the-minute overview of all office activity.</p>

            At-a-glance tools include:
            <ul class="list-unstyled">
                <li>Calendar</li>
                <li>ToDo's with visual status indicators</li>
                <li>Patient Tracker with color coding</li>
                <li>Detailed message list with patient identifiers</li>
                <li>Appointment schedule</li>
            </ul>
        </div>
        <div class="col-md-4">
            <img class="img-responsive pull-right" src="/Images/EMR/PracticeView.jpg" alt="Practice View"/>
        </div>
    </div>

    <hr />

    <div class="row">
        <div class="col-md-8">
            <h4 class="text-primary">Patient Chart</h4>
            <p>The Patient Chart provides a comprehensive and logical view of all data related to a specific patient. Static elements are on the left and events are listed by category in an "event tree" on the right.</p>

            <h5 class="text-primary"><b>Static Information:</b></h5>
            <ul class="list-unstyled">
                <li>Demographics</li>
                <li>Allergies</li>
                <li>Problem List</li>
                <li>Other Sensitivities</li>
                <li>Routine Meds</li>
                <li>Previous Medical History</li>
                <li>Referring Doctor</li>
                <li>Family Medical History</li>
                <li>Chart Note</li>
                <li>Social History</li>
                <li>Insurance</li>
            </ul>

            <h5 class="text-primary margin-top-sm"><b>Events:</b></h5>
            <ul class="list-unstyled">        
                <li>Encounters</li>
                <li>Immunizations</li>
                <li>Labs</li>
                <li>Imaging</li>
                <li>Medical Tests</li>
                <li>Flow Sheets</li>
                <li>Text Records</li>
                <li>Excuses/Notes</li>
                <li>Additional User-Definable Categories</li>
            </ul>
        </div>
        <div class="col-md-4">
            <img class="img-responsive pull-right" src="/Images/EMR/PatientChart.jpg" alt="Patient Chart"/>
        </div>
    </div>

    <hr />

    <div class="row">
        <div class="col-md-8">
            <h4 class="text-primary">Office Visit</h4>
            <p>Our EMR Software's Office Visit screen enables rapid and complete documentation of an entire office visit with little or no typing.<br />Elements Include:</p>

            <h5 class="text-primary"><b>Classic SOAP Format:</b></h5>
            <ul class="list-unstyled">
                <li>(S) Subjectives</li>
                <li>(O) Objectives</li>
                <li>(A) Assessment</li>
                <li>(P) Plan</li>
                <li>PopUp Text</li>
                <li>PopUp Text List</li>
                <li>(middle panel) is variable and corresponds to the OV component currently in use by the practitioner.</li>
            </ul>

            <h5 class="text-primary margin-top-sm"><b>OV Components:</b></h5>
            <ul class="list-unstyled">        
                <li>Chief Complaint</li>
                <li>Review of Systems</li>
                <li>Vitals</li>
                <li>Examination</li>
                <li>Diagnoses</li>
                <li>Prescriptions</li>
                <li>Tests</li>
                <li>Procedures</li>
                <li>Other Treatment</li>
                <li>Follow-up</li>
            </ul>
        </div>
        <div class="col-md-4">
            <img class="img-responsive pull-right" src="/Images/EMR/OfficeVisit.jpg" alt="Office Visit"/>
        </div>
    </div>
    

</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ScriptsContent" Runat="Server">
</asp:Content>

