﻿<%@ Page Title="Electronic Medical Billing" Language="C#" MasterPageFile="~/Site.master" AutoEventWireup="true" CodeFile="additional-revenue.aspx.cs" Inherits="calculate_additional_revenue" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CssContent" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="BodyRootContent" runat="Server">
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="SliderContent" runat="Server">
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="MainContent" runat="Server">
    <div class="page-header">
        <h3 class="page-heading">CALCULATE YOUR SAVINGS<br />
            <small>See Your Savings Using Our Electronic Fund Transfer (EFT).</small></h3>
    </div>

    <%if (!string.IsNullOrWhiteSpace((string)ViewState["Message"]))
      {
    %>
    <div class="alert alert-danger">
        <%= ViewState["Message"] %>
    </div>
    <%
          } 
    %>

    <p>
        <strong>Instructions: </strong>Complete the fields listed under "Enter Your Numbers Here". Do not use decimals. 
        To request a detailed analysis of EFT and/or complete billing 
        cost analysis for your practice, 
        please <a target="_blank" title="Contact Us" href="/contact-us.aspx">contact us</a> today!

    </p>
    <table class="table table-condensed table-hover table-striped table-bordered table-responsive table-calculate">
        <tr class="info">
            <th>Electronic Fund Transfer</th>
            <th>Average Provider Without EFT</th>
            <th>Average Provider Using EFT</th>
            <th>Enter Your Numbers Here</th>
            <th>Description</th>
        </tr>
        <tr>
            <td>Number of Outstanding Accounts Annually</td>
            <td>100</td>
            <td>100</td>
            <td>
                <asp:RequiredFieldValidator ForeColor="Red" ID="RequiredFieldValidator1" runat="server"
                    ControlToValidate="txtnumberAccount" ErrorMessage="*"
                    ValidationGroup="GetMyREVENUE" Display="Dynamic"></asp:RequiredFieldValidator>
                <asp:TextBox ID="txtnumberAccount" class="form-control" runat="server"></asp:TextBox>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="The Average Number of Outstanding Accounts Annually. " /></td>
        </tr>
        <tr>
            <td>Average Outstanding Balance Per Account</td>
            <td>$400</td>
            <td>$400</td>
            <td>
                <asp:RequiredFieldValidator ForeColor="Red" ID="RequiredFieldValidator2" runat="server"
                    ControlToValidate="txtaverageOutStandingBalance" ErrorMessage="*"
                    ValidationGroup="GetMyREVENUE"></asp:RequiredFieldValidator>
                <div class="form-group">
                    <div class="input-group">
                        <i class="glyphicon glyphicon-usd input-group-addon"></i>
                        <asp:TextBox ID="txtaverageOutStandingBalance" CssClass="form-control" runat="server"></asp:TextBox>
                    </div>
                </div>
            </td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="The Average amount of Outstanding Balance Per Account. " /></td>
        </tr>
        <tr>
            <td>Total Amount of Money  Outstanding Annually	</td>
            <td>$40,000</td>
            <td>$40,000</td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="Total of Outstanding Balances Annually is the result of multiplying Number of Past-Due Accounts Annually and Average Outstanding Balance. " /></td>
        </tr>
        <tr>
            <td>Percentage of Outstanding Balances Never Recovered	</td>
            <td>45%</td>
            <td>3%</td>
            <td>
                <asp:RequiredFieldValidator ForeColor="Red" ID="RequiredFieldValidator3" runat="server"
                    ControlToValidate="txtpercentageNeverCollected" ErrorMessage="*"
                    ValidationGroup="GetMyREVENUE"></asp:RequiredFieldValidator>
                <div class="form-group">
                    <div class="input-group">
                        <asp:TextBox ID="txtpercentageNeverCollected" CssClass="form-control" runat="server"></asp:TextBox>
                        <i class="glyphicon input-group-addon"><b>%</b></i>
                    </div>
                </div>

            </td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="Percentage of Outstanding Balances Never Recovered without using EFT is 45% in 
                    compare with 3% using EFT. Feel free to enter the rate using your current system. " /></td>
        </tr>
        <tr>
            <td>Annual Lost Revenue from  Accounts Not-Collected	</td>
            <td>$18,000</td>
            <td>$1200</td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="Annual Lost Revenue from  Accounts Not-Collected is calculated by multiplyingTotal Amount of Money  Outstanding Annually by Percentage of Outstanding Balances Never Recovered. " /></td>
        </tr>
        <tr>
            <td><b>Revenue from Outstanding Accounts Recovered Annually  Using EFT	</b></td>
            <td>$16,800</td>
            <td>$16,800</td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="By deduction Annual Lost Revenue from  Accounts Not-Collected using EFT from Annual Lost Revenue from  Accounts Not-Collected without using EF the Revenue from Outstanding Accounts Recovered Annually Using EFT is calculated. " /></td>
        </tr>
        <tr>
            <td>Number of Patients Rejected Annually that Cannot Pay but Would Have Qualified for EFT</td>
            <td>40</td>
            <td>0</td>
            <td>
                <asp:RequiredFieldValidator ForeColor="Red" ID="RequiredFieldValidator4" runat="server"
                    ControlToValidate="txtpatientsRejected" ErrorMessage="*"
                    ValidationGroup="GetMyREVENUE" Display="Dynamic"></asp:RequiredFieldValidator>
                <asp:TextBox ID="txtpatientsRejected" class="form-control" runat="server">40</asp:TextBox>
            </td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="Number of Patients Rejected Annually that Cannot Pay but Would Have Qualified for EFT. " />
            </td>
        </tr>
        <tr>
            <td>Average Amount Billed to Each New Patient</td>
            <td>$700</td>
            <td>$700</td>
            <td>
                <div class="form-group">
                    <asp:RequiredFieldValidator ForeColor="Red" ID="RequiredFieldValidator5" runat="server"
                        ControlToValidate="txtamountBilledNewPatient" ErrorMessage="*"
                        ValidationGroup="GetMyREVENUE"></asp:RequiredFieldValidator>
                    <div class="input-group">
                        <i class="glyphicon glyphicon-usd input-group-addon"></i>
                        <asp:TextBox ID="txtamountBilledNewPatient" class="form-control" runat="server"></asp:TextBox>
                    </div>
                </div>
            </td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="Average Amount Billed to Each New Patient. " />
            </td>
        </tr>
        <tr>
            <td>Annual Revenue Lost Due to Rejected Patients as a result of Credit Risk</td>
            <td>$28,000</td>
            <td>$0</td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="Annual Revenue Lost Due to Rejected Patients as a result of Credit Risk is calculated by multiplying Number of Patients Rejected Annually that Cannot Pay but Would Have Qualified for EFT by Average Amount Billed to Each New Patient." />
            </td>
        </tr>
        <tr>
            <td>Revenue From Credit Risk Patients Annually using EFT</td>
            <td>$28,000</td>
            <td>$28,000</td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="Revenue From Credit Risk Patients Annually using EFT is calculated by Annual Revenue Lost using EFT system from Annual Revenue Lost without using EFT system." />
            </td>
        </tr>
        <tr class="success">
            <td><b>Total Combined Income From EFT Annually (Outstanding Balances + Credit Risk Accounts)	</b></td>
            <td colspan="2"><b>$44,800</b></td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="Total Combined Income From EFT Annually (Outstanding Balances + Credit Risk Accounts.  " /></td>
        </tr>
        <tr>
            <td colspan="5">
                <asp:Button ID="ImageButton1" CssClass="btn btn-primary" Text="GO TO RESULT" ValidationGroup="GetMyREVENUE" runat="server" OnClick="ImageButton1_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsContent" runat="Server">
    <script>
        $(function () { $("[data-toggle='tooltip']").tooltip(); });
    </script>
</asp:Content>
