<%@ Page Title="Electronic Medical Billing" Language="C#" MasterPageFile="~/Site.master" AutoEventWireup="true" CodeFile="billing-savings.aspx.cs" Inherits="calculate_billing_savings" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CssContent" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="BodyRootContent" runat="Server">
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="SliderContent" runat="Server">
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="MainContent" runat="Server">
    <div class="page-header">
        <h3 class="page-heading">CALCULATE YOUR SAVINGS<br />
            <small>See How Our Electronic Medical Billing System Can Save You Money & Improve Your Bottom Line...</small></h3>
    </div>

    <%if (!string.IsNullOrWhiteSpace((string)ViewState["Message"]))
      {
    %>
    <div class="alert alert-danger">
        <%= ViewState["Message"] %>
    </div>
    <%
          } 
    %>

    <p>
        <strong>Instructions: </strong>Complete the fields listed under "Enter Your Figures" 
        column. Do not use decimals. To request a detailed analysis of codes and/or complete 
        billing cost analysis for your practice,
        please <a target="_blank" title="Contact Us" href="/contact-us.aspx">contact us</a> today!
    </p>

    <table class="table table-condensed table-hover table-striped table-bordered table-responsive table-calculate">
        <tr class="info">
            <th>Insurance Claims Filing</th>
            <th>National Average: Providers Filing Paper Claims</th>
            <th>National Average: Providers Filing Electronically</th>
            <th>Enter Your Figures</th>
            <th>Description</th>
        </tr>

        <tr>
            <td>Number of Insurance Claims Filed Annually</td>
            <td>5,760</td>
            <td>5,760</td>
            <td>
                <asp:RequiredFieldValidator ForeColor="Red" ID="RequiredFieldValidator1" runat="server"
                    ControlToValidate="txtnumberClaim" ErrorMessage="* Required"
                    ValidationGroup="GetMyResult" Display="Dynamic"></asp:RequiredFieldValidator>

                <asp:TextBox ID="txtnumberClaim" CssClass="form-control" runat="server"></asp:TextBox></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left" title="According to National Average, number of provider's insurance claims is 480 per month which will be 5,760 annually. Feel free to enter your average insurance claims per year." /></td>
        </tr>
        <tr>
            <td>Average Value Per Claim</td>
            <td>$180</td>
            <td>$180</td>
            <td>
                <asp:RequiredFieldValidator ForeColor="Red" ID="RequiredFieldValidator2" runat="server"
                    ControlToValidate="txtaverageAmountPerClaim" ErrorMessage="* Required"
                    ValidationGroup="GetMyResult"></asp:RequiredFieldValidator>
                <div class="form-group">
                    <div class="input-group">
                        <i class="glyphicon glyphicon-usd input-group-addon"></i>
                        <asp:TextBox ID="txtaverageAmountPerClaim" CssClass="form-control" runat="server"></asp:TextBox>
                    </div>
                </div>
            </td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left" title="Claim values will vary, depending on medical speciality, number of services performed, approved insurance rate, and other factors. In general, you might use an average of $50 to $300 you will collect per claim from the insurer and the patient. Some claims can reach as high as $1000 or $5000 if you are billing for specialists. Use an average here.  " /></td>
        </tr>
        <tr>
            <td>Total Annual Insurance Billing	</td>
            <td>$1,036,800</td>
            <td>$1,036,800</td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left" title="Total Annual Insurance Billing, is the Number of Insurance Claims Filed Annually multiply by Average Value Per Claim.  " /></td>
        </tr>
        <tr>
            <td>Percentage of Rejected Claims	</td>
            <td>25%</td>
            <td>1%</td>
            <td>
                <asp:RequiredFieldValidator ForeColor="Red" ID="RequiredFieldValidator3" runat="server"
                    ControlToValidate="txtpercentageRejectedClaim" ErrorMessage="* Required"
                    ValidationGroup="GetMyResult" Display="Dynamic"></asp:RequiredFieldValidator>
                <div class="form-group">
                    <div class="input-group">
                        <asp:TextBox ID="txtpercentageRejectedClaim" CssClass="form-control" runat="server"></asp:TextBox>
                        <i class="glyphicon input-group-addon"><b>%</b></i>
                    </div>
                </div>
            </td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left" title="According to National Average, 25% of  insurance claims get rejected if they were filed by paper and only 1% of insurance claims get rejected if filed electronically, feel free to enter your practice rejected claim's rate. " /></td>
        </tr>
        <tr>
            <td>Number of Rejected Claims	</td>
            <td>1,440</td>
            <td>58</td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left" title="According to the percentage you entered for Percentage of Rejected Claims, here you see the number of rejected claims you got. " /></td>
        </tr>
        <tr>
            <td><b>Amount of Rejected Claims	</b></td>
            <td>$259,200</td>
            <td>$10,368</td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left" title="By multiplying Number of Rejected Claims by Average Value Per Claim the Amount of  Rejected Claims is calculated. " /></td>
        </tr>
        <tr>
            <td>Percentage of Rejected Claims Never Collected</td>
            <td>40%</td>
            <td>40%</td>
            <td>
                <div class="form-group">
                    <asp:RequiredFieldValidator ForeColor="Red" ID="RequiredFieldValidator4" runat="server"
                        ControlToValidate="txtpercentageRejectedNeverRecovered" ErrorMessage="*"
                        ValidationGroup="GetMyResult"></asp:RequiredFieldValidator>
                    <div class="input-group">
                        <asp:TextBox ID="txtpercentageRejectedNeverRecovered" CssClass="form-control" runat="server">40</asp:TextBox>
                        <i class="glyphicon input-group-addon"><b>%</b></i>
                    </div>
                </div>
            </td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left" title="According to National Average, Percentage of Rejected Claims Never Collected is 40% while filling by paper or electronically. We suggest you put 40%, but if you case is a special case, feel free to enter your percentage. " /></td>
        </tr>
        <tr>
            <td><b>Total of Claims Never Collected	</b></td>
            <td>$103,680</td>
            <td>$4,147</td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left" title="Total of Claims Never Collected is the Percentage of Rejected Claims Never Collected times by Amount of  Rejected Claims. " /></td>
        </tr>
        <tr class="success">
            <td><b>Savings From Using Electronic Submission	</b></td>
            <td colspan="3"><b>$99,533</b></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left" title="By deducting the amount of Total of Claims Never Collected if filed electronically from Total of Claims Never Collected if filed paper claims, you can see how much you can save by using Electronic Submission. " /></td>
        </tr>
        <tr>
            <td colspan="5">
                <asp:Button ID="ImageButton1" CssClass="btn btn-primary" Text="GO TO RESULT" ValidationGroup="GetMyResult" runat="server" OnClick="ImageButton1_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsContent" runat="Server">
    <script>
        $(function () { $("[data-toggle='tooltip']").tooltip(); });
    </script>
</asp:Content>

