﻿<%@ Page Title="Creative Collection" Language="C#" MasterPageFile="~/Site.master" AutoEventWireup="true" CodeFile="collection-revenue.aspx.cs" Inherits="calculate_collection_revenue" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CssContent" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="BodyRootContent" runat="Server">
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="SliderContent" runat="Server">
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="MainContent" runat="Server">
    <div class="page-header">
        <h3 class="page-heading">CALCULATE YOUR SAVINGS<br />
            <small>See How Our Creative Collection Solutions Can Increase Cash Flow.</small></h3>
    </div>

    <%if (!string.IsNullOrWhiteSpace((string)ViewState["Message"]))
      {
    %>
    <div class="alert alert-danger">
        <%= ViewState["Message"] %>
    </div>
    <%
          } 
    %>

    <p>
        <strong>Instructions: </strong>Complete the fields listed under "Enter Your Numbers Here" column. 
        Do not use decimals. To request a detailed analysis of collections and/or billing cost for your practice, 
        please <a target="_blank" title="/Contact Us" href="/contact-us.aspx">contact us</a> today!
    </p>

    <table class="table table-condensed table-hover table-striped table-bordered table-responsive table-calculate">
        <tr class="info">
            <th>Collection Services</th>
            <th>Average Provider Using Traditional Collections</th>
            <th>Average Provider Using Our System</th>
            <th>Enter Your Numbers Here</th>
            <th>Description</th>
        </tr>

        <tr>
            <td>Number of Past-Due Accounts Annually</td>
            <td>100</td>
            <td>100</td>
            <td>
                <asp:RequiredFieldValidator ForeColor="Red" ID="RequiredFieldValidator1" runat="server"
                    ControlToValidate="txtnumberUncollectedAccount" ErrorMessage="*"
                    ValidationGroup="GetMyCollection" Display="Dynamic"></asp:RequiredFieldValidator>
                <asp:TextBox ID="txtnumberUncollectedAccount" CssClass="form-control" runat="server"></asp:TextBox></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="The Average Number of Past-Due Accounts per year. " /></td>
        </tr>
        <tr>
            <td>Average Outstanding Balance</td>
            <td>$400</td>
            <td>$400</td>
            <td>
                <asp:RequiredFieldValidator ForeColor="Red" ID="RequiredFieldValidator2" runat="server"
                    ControlToValidate="txtaverageOutstandingBalance" ErrorMessage="*"
                    ValidationGroup="GetMyCollection" Display="Dynamic"></asp:RequiredFieldValidator>
                <div class="form-group">
                    <div class="input-group">
                        <i class="glyphicon glyphicon-usd input-group-addon"></i>
                        <asp:TextBox ID="txtaverageOutStandingBalance" CssClass="form-control" runat="server"></asp:TextBox>
                    </div>
                </div>
            </td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="The Average amount of Outstanding Balance. " /></td>
        </tr>
        <tr>
            <td>Total of Outstanding Balances Annually	</td>
            <td>$40,000</td>
            <td>$40,000</td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="Total of Outstanding Balances Annually is the result of multiplying Number of Past-Due Accounts Annually and Average Outstanding Balance. " /></td>
        </tr>
        <tr>
            <td>Average Percentage of Money Recovered	</td>
            <td>10%</td>
            <td>45%</td>
            <td>45%</td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="The Average Percentage of Money Recovered is 10% using traditional collections, however it is 45% using our system. " />
            </td>
        </tr>
        <tr>
            <td>Annual Revenue Collected from Outstanding Accounts	</td>
            <td>$4,000</td>
            <td>$18,000</td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="Annual Revenue Collected from Outstanding Accounts using our system is calculated by multiplying Total of Outstanding Balances Annually by 45%.  " /></td>
        </tr>
        <tr>
            <td><b>Average Cost to Collect Each Account	</b></td>
            <td>40%</td>
            <td>4%</td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="Average Cost to Collect Each Account is 40% using traditional collections in compare with only 4% using our collection system. " /></td>
        </tr>
        <tr>
            <td>Total Annual Cost to Collect Accounts</td>
            <td>$1,600</td>
            <td>$720</td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="Total Annual Cost to Collect Accounts is calculated by multiplying Annual Revenue Collected from Outstanding Accounts by Average Cost to Collect Each Account.  " /></td>
        </tr>
        <tr class="success">
            <td><b>Revenue Recovered Annually!	</b></td>
            <td><b>$14,880</b></td>
            <td></td>
            <td></td>
            <td>
                <i class="glyphicon glyphicon-info-sign" data-toggle="tooltip" data-placement="left"
                    title="Revenue Recovered Annually is calculated by the following formula: (Annual Revenue Collected from Outstanding Accounts using Our System) - (Total Annual Cost to Collect Accounts using Our System) )  -  (Annual Revenue Collected from Outstanding Accounts using Traditional Collection System ) - (Total Annual Cost to Collect Accounts using Traditional Collection System) ). " /></td>
        </tr>
        <tr>
            <td colspan="5">
                <asp:Button CssClass="btn btn-primary" Text="GO TO RESULT" ValidationGroup="GetMyCollection" runat="server" OnClick="ImageButton1_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
<asp:Content ID="Content5" ContentPlaceHolderID="ScriptsContent" runat="Server">
    <script>
        $(function () { $("[data-toggle='tooltip']").tooltip(); });
    </script>
</asp:Content>

