<%@ Page Title="Contact" Async="true" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeFile="Contact-Us.aspx.cs" Inherits="Contact" %>

<%@ Register Assembly="Recaptcha.Web" Namespace="Recaptcha.Web.UI.Controls" TagPrefix="cc1" %>

<asp:Content ID="BodyContent" ContentPlaceHolderID="MainContent" runat="server">

    <div class="page-header">
        <h3 class="page-heading">CONTACT US<br />
            <label><%= Session["CompanyName"].ToString()%></label></h3>
    </div>
    <p style="font-size:16px;">
        <strong><%= Session["CompanyName"].ToString()%></strong> is a professional billing service
        dedicated to meeting all of the insurance and patient billing needs of your practice.
        We offer a variety of personalized services that can meet the needs of medical &amp;
        dental practices.
    </p>

    <div class="well well-sm" >
        <div id="successMessage" visible="false" class="alert alert-success" runat="server">
            <h4><strong>
                <span class=" glyphicon glyphicon-send" style="float: right; font-size: 30px;"></span>

                Thank you for your interest in our service.
                        <br />
                We will contact you shortly.
            </strong></h4>
        </div>
        <address class="no-margin">
            <p class="lead no-margin" style="font-size:16px;">
                Address:  <a target="_blank"
                    href="https://www.google.com/maps/preview?ie=UTF-8&q=<%= Session["CompanyName"].ToString()%>&fb=1&gl=us&hq=<%= Session["Address"].ToString()%>+<%= Session["City"].ToString()%>,+<%= Session["State"].ToString()%>+<%= Session["Zip"].ToString()%>">
                    <%= Session["Address"].ToString()%> <%= Session["City"].ToString()%>, 
                        <%= Session["State"].ToString()%> <%= Session["Zip"].ToString()%>
                </a>
                <br>
                Phone: <%= Session["Phone"].ToString()%><br />
                Fax:  <%= Session["Fax"].ToString()%>
            </p>
        </address>
    </div>
    <div class="row">
        <h4>Please indicate which of the following services you wish to receive information on: </h4>

        <div class="col-sm-6">
            <asp:CheckBox ID="chkpractice_man" CssClass="checkbox-inline" runat="server" Text=" Billing/Practice Management Services" />
            <br />
            <asp:CheckBox ID="chkcollections" CssClass="checkbox-inline" runat="server" Text=" Collection Services" />
            <br />
            <asp:CheckBox ID="chkeft" CssClass="checkbox-inline" runat="server" Text=" Electronic Fund Transfer (EFT)" />
            <br />
            <asp:CheckBox ID="chkwellcare" CssClass="checkbox-inline" runat="server" Text=" Well-Care Services" />
            <br />
            <asp:CheckBox ID="chktranscription" CssClass="checkbox-inline" runat="server" Text=" Transcription Services" />
            <br />
            <asp:CheckBox ID="chkscanning" CssClass="checkbox-inline" runat="server" Text=" Document Management Services" />
            <br />
            <asp:CheckBox ID="chkrbs" CssClass="checkbox-inline" runat="server" Text=" Secure Remote Backup Services (RBS)" />
            <br />
            <asp:CheckBox ID="chkCodeMAXXServices" CssClass="checkbox-inline" runat="server" Text=" CodeMAXX Services" />
            <br />
        </div>
        <div class="col-sm-6">
            <asp:CheckBox ID="chkmpms" CssClass="checkbox-inline" runat="server" Text=" Interested in Medical Software" />
            <br />
            <asp:CheckBox ID="chkdpms" CssClass="checkbox-inline" runat="server" Text=" Interested in Dental Software" />
            <br />
            <asp:CheckBox ID="chkemr" CssClass="checkbox-inline" runat="server" Text=" Interested in EMR Software" />
            <br />
            <asp:CheckBox ID="chkcost_anal" CssClass="checkbox-inline" runat="server" Text=" Billing Codes and Cost Analysis" />
            <br />
            <asp:CheckBox ID="chkPatientAssessment_PAS" CssClass="checkbox-inline" runat="server" Text=" Patient Assessment (P.A.S.)" />
            <br />
            <asp:CheckBox ID="chkCustomWellnessProgram" CssClass="checkbox-inline" runat="server" Text=" Custom Wellness Program" />
            <br />
            <asp:CheckBox ID="chkMDAuditShield" CssClass="checkbox-inline" runat="server" Text=" MD Audit Shield - RAC" />
            <br />
            <asp:CheckBox ID="chkPhysicianCredentialing" CssClass="checkbox-inline" runat="server" Text=" Physician Credentialing" />
            <br />
        </div>
    </div>
    <hr />

    <div class="row">
        <h4>Please complete the form below or contact us at the number at the top of the page:
        </h4>

        <div class="col-sm-6">
            <div class="form-group">
                <label for="txtName">Name</label>
                <div class="input-group">
                    <asp:TextBox CssClass="form-control" ID="txtName" runat="server"></asp:TextBox>
                    <span class="input-group-addon"><i class="glyphicon glyphicon-ok"></i>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="txtName"
                            ValidationGroup="submit" Display="Dynamic"><img alt="Name field is required." src="images/Exclamation_mark_red.png" /></asp:RequiredFieldValidator>
                    </span>

                </div>
            </div>
            <div class="form-group">
                <label for="txtTitle">Title</label>
                <div class="input-group">
                    <asp:TextBox CssClass="form-control" ID="txtTitle" runat="server"></asp:TextBox>
                    <span class="input-group-addon"><i class="glyphicon glyphicon-ok"></i>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="txtTitle"
                            ValidationGroup="submit" Display="Dynamic"><img 
                                    alt="Title field is required." src="images/Exclamation_mark_red.png" /></asp:RequiredFieldValidator>
                    </span>
                </div>
            </div>
            <div class="form-group">
                <label for="txtPracticeName">Practice Name</label>
                <div class="input-group">
                    <asp:TextBox CssClass="form-control" ID="txtPracticeName" runat="server"></asp:TextBox>
                    <span class="input-group-addon"><i class="glyphicon glyphicon-ok"></i>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="txtPracticeName"
                            ValidationGroup="submit" Display="Dynamic"><img 
                                    alt="Practice Name field is required." src="images/Exclamation_mark_red.png" /></asp:RequiredFieldValidator>
                    </span>
                </div>
            </div>

            <div class="form-group">
                <label for="txtTelephone">Phone #</label>
                <div class="input-group">
                    <asp:TextBox CssClass="form-control" ID="txtTelephone" runat="server"></asp:TextBox>
                    <span class="input-group-addon"><i class="glyphicon glyphicon-ok"></i>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator8" runat="server" ControlToValidate="txtTelephone"
                            ValidationGroup="submit" Display="Dynamic"><img 
                                    alt="Telephone field is required." src="images/Exclamation_mark_red.png" /></asp:RequiredFieldValidator>
                        <asp:RegularExpressionValidator ID="RegularExpressionValidator5" runat="server" ControlToValidate="txtTelephone"
                            ErrorMessage="xxx-xxx-xxxx" ValidationExpression="\b\d{3}[-.]?\d{3}[-.]?\d{4}\b"
                            ValidationGroup="submit" Display="Dynamic" ForeColor="#CC0000"></asp:RegularExpressionValidator>
                    </span>
                </div>
            </div>
            <div class="form-group">
                <label for="txtEmail">Email</label>
                <div class="input-group">
                    <asp:TextBox CssClass="form-control" ID="txtEmail" runat="server"></asp:TextBox>
                    <span class="input-group-addon"><i class="glyphicon glyphicon-ok"></i>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator7" runat="server" ControlToValidate="txtEmail"
                            ValidationGroup="submit" Display="Dynamic"><img 
                                    alt="Email field is required." src="images/Exclamation_mark_red.png" /></asp:RequiredFieldValidator>
                        <asp:RegularExpressionValidator ID="RegularExpressionValidator3" runat="server" ControlToValidate="txtEmail"
                            ErrorMessage="InvalidEmail" ValidationExpression="\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*"
                            ValidationGroup="submit" Display="Dynamic" ForeColor="#CC0000"></asp:RegularExpressionValidator>
                    </span>

                </div>
            </div>
            <div class="form-group">
                <label for="txtMessage">Message</label>
                <div class="input-group">
                    <asp:TextBox CssClass="form-control" ID="txtMessage" TextMode="MultiLine" Rows="6" runat="server"></asp:TextBox>
                    <span class="input-group-addon"><i class="glyphicon glyphicon-pencil"></i></span>
                </div>
            </div>
        </div>
        <div class="col-sm-5 col-sm-push-1 ">
            <div class="form-group">
                <label for="txtAddress">Address</label>
                <div class="input-group">
                    <asp:TextBox CssClass="form-control" ID="txtAddress" runat="server"></asp:TextBox>
                    <span class="input-group-addon"><i class="glyphicon glyphicon-ok"></i>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ControlToValidate="txtAddress"
                            ValidationGroup="submit" Display="Dynamic"><img 
                                    alt="Address field is required." src="images/Exclamation_mark_red.png" /></asp:RequiredFieldValidator>
                    </span>
                </div>
            </div>
            <div class="form-group">
                <label for="InputName">City</label>
                <div class="input-group">
                    <asp:TextBox CssClass="form-control" ID="txtCity" runat="server"></asp:TextBox>
                    <span class="input-group-addon"><i class="glyphicon glyphicon-ok"></i>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator5" runat="server" ControlToValidate="txtCity"
                            ValidationGroup="submit" Display="Dynamic"><img 
                                    alt="Address field is required." src="images/Exclamation_mark_red.png" /></asp:RequiredFieldValidator>
                    </span>

                </div>
            </div>
            <div class="form-group">
                <label for="txtState">State</label>
                <div class="input-group">
                    <asp:TextBox CssClass="form-control" ID="txtState" runat="server"></asp:TextBox>
                    <span class="input-group-addon"><i class="glyphicon glyphicon-ok"></i>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator6" runat="server" ControlToValidate="txtState"
                            ValidationGroup="submit" Display="Dynamic"><img 
                                    alt=" State field is required." src="images/Exclamation_mark_red.png" /></asp:RequiredFieldValidator>
                    </span>

                </div>
            </div>
            <div class="form-group">
                <label for="txtZipcode">Zipcode</label>
                <div class="input-group">
                    <asp:TextBox CssClass="form-control" ID="txtZipcode" runat="server"></asp:TextBox>
                    <span class="input-group-addon"><i class="glyphicon glyphicon-ok"></i>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator9" runat="server" ControlToValidate="txtZipcode"
                            ValidationGroup="submit" Display="Dynamic"><img 
                                    alt="Zip code field is required." src="images/Exclamation_mark_red.png" /></asp:RequiredFieldValidator>
                        <asp:RegularExpressionValidator ID="RegularExpressionValidator4" runat="server" ControlToValidate="txtZipcode"
                            ErrorMessage="Invalid Zip code" ValidationExpression="\d{5}(-\d{4})?" ValidationGroup="submit"
                            Display="Dynamic" ForeColor="#CC0000"></asp:RegularExpressionValidator>
                    </span>
                </div>
            </div>
            <div id="recapthca">
                <cc1:Recaptcha ID="Recaptcha1" PublicKey="6Lf5yMISAAAAACrgnm1-n7cxx1LZzWfJLry3a0S6"
                    PrivateKey="6Lf5yMISAAAAAMRPqBDbJ6RsmmG-3vwzRAiUpcrf" runat="server" />
                <asp:Label ID="lblRecaptcha" runat="server" Font-Bold="True" ForeColor="Red"
                    Visible="true" Font-Size="10px"></asp:Label>
            </div>

            <div class="form-group">
                <asp:LinkButton ID="submit" ValidationGroup="submit" CausesValidation="true"
                    CssClass="btn btn-info btn-lg margin-top-md btn-width-max" OnClick="submit_Click" runat="server">
                    <i aria-hidden="true" class="glyphicon glyphicon-send pull-right"> </i> Send
                </asp:LinkButton>
            </div>
        </div>
    </div>

</asp:Content>
