﻿using Recaptcha.Web;
using System;
using System.Net.Mail;
using System.Text;
using System.Web;
using System.Web.UI;

public partial class Contact : Page
{

    string domain = string.Empty;

    protected void Page_Load(object sender, EventArgs e)
    {
        this.domain = HttpContext.Current.Request.Url.Host;
    }

    protected void btnClear_Click(object sender, ImageClickEventArgs e)
    {
        clearForm();
    }

    private void clearForm()
    {
        txtName.Text = "";
        txtTitle.Text = "";
        txtPracticeName.Text = "";
        txtAddress.Text = "";
        txtCity.Text = "";
        txtState.Text = "";
        txtZipcode.Text = "";
        txtTelephone.Text = "";
        txtEmail.Text = "";
        txtMessage.Text = "";
    }
    protected async void submit_Click(object sender, EventArgs e)
    {
        if (String.IsNullOrEmpty(Recaptcha1.Response))
        {
            lblRecaptcha.Text = "Captcha cannot be empty.";
        }
        else
        {
            RecaptchaVerificationResult result = await Recaptcha1.VerifyTaskAsync();

            if (result == RecaptchaVerificationResult.Success)
            {
                string URL = Request.Url.ToString(); //Getting the Existing URL
                MailMessage message = new MailMessage();
                message.From = new MailAddress(txtEmail.Text);
                message.To.Add(new MailAddress(Session["Email"].ToString()));
                message.Subject = "Information Request Form";
                message.IsBodyHtml = true;
                StringBuilder body = new StringBuilder();
                string strDate = DateTime.Now.ToShortDateString();              //Getting the Date (Short)
                body.Append(txtName.Text);
                body.Append(" just completed the contact form." + "<br/ ><br/ >" + "They stated that...<br/ ><br/ >");
                body.Append("<table bgcolor = '#FCFCFC' style=\"border: 1px solid #C0C0C0\">");
                body.Append("<tr><td  colspan = 2><h2>" + "Form Submitted on " + strDate + "</h2></td></tr>");
                body.Append("<tr><td width = '30%'>" + "Title: " + "</td><td><b>" + txtTitle.Text + "</b></td></tr>");
                body.Append("<tr><td width = '30%'>" + "Name: " + "</td><td><b>" + txtName.Text + "</b></td></tr>");
                body.Append("<tr><td width = '30%'>" + "Practice Name: " + "</td><td><b>" + txtPracticeName.Text + "</b></td></tr>");
                body.Append("<tr><td width = '30%'>" + "Address: " + "</td><td><b>" + txtAddress.Text + "</b></td></tr>");
                body.Append("<tr><td width = '30%'>" + "City: " + "</td><td><b>" + txtCity.Text + "</b></td></tr>");
                body.Append("<tr><td width = '30%'>" + "State: " + "</td><td><b>" + txtState.Text + "</b></td></tr>");
                body.Append("<tr><td width = '30%'>" + "Zip Code: " + "</td><td><b>" + txtZipcode.Text + "</b></td></tr>");
                body.Append("<tr><td width = '30%'>" + "Telephone #: " + "</td><td><b>" + txtTelephone.Text + "</b></td></tr>");
                body.Append("<tr><td width = '30%'>" + "Email: " + "</td><td><b>" + txtEmail.Text + "</b></td></tr>");
                body.Append("<tr><td width = '30%'>" + "Message: " + "</td><td><b>" + txtMessage.Text + "</b></td></tr>");
                body.Append("<tr><td width = '30%'>" + "URL: " + " " + " " + "</td><td>" + URL + "</td></tr>");
                body.Append("<tr><td width = '30%'></td><td>" + "<br>" + "</td></tr></table><br><br>");
                body.Append("They also checked the following...<br><br>");

                body.Append("<table  cellspacing = 0 cellpadding = 0 width = '70%' border = 0>");
                body.Append("<tr><td bgcolor = 'Cornsilk'><b>Services</b></td><td bgcolor = 'Cornsilk' align = center><b>Requested</b></td></tr>");
                body.Append("<tr><td width = '60%'>" + "Billing/Practice Management Services: " + "</td><td align = center><b>" + chkpractice_man.Checked + "</b></td></tr>");
                body.Append("<tr><td width = '60%'>" + "Collection Services: " + "</td><td align = center><b>" + chkcollections.Checked + "</b></td></tr>");
                body.Append("<tr><td width = '60%'>" + "Secure Remote Backup Services (RBS): " + "</td><td align = center><b>" + chkrbs.Checked + "</b></td></tr>");
                body.Append("<tr><td width = '60%'>" + "Electronic Fund Transfer (EFT): " + "</td><td align = center><b>" + chkeft.Checked + "</b></td></tr>");
                body.Append("<tr><td width = '60%'>" + "Digital Scanning + Archiving of Medical Records: " + "</td><td align = center><b>" + chkscanning.Checked + "</b></td></tr>");
                body.Append("<tr><td width = '60%'>" + "Well Care Services: " + "</td><td align = center><b>" + chkwellcare.Checked + "</b></td></tr>");
                body.Append("<tr><td width = '60%'>" + "interested in Medical Practice Management Software Sales: " + "</td><td align = center><b>" + chkdpms.Checked + "</b></td></tr>");
                body.Append("<tr><td width = '60%'>" + "interested in EMR Software Sales: " + "</td><td align = center><b>" + chkemr.Checked + "</b></td></tr>");
                //     + "<tr><td width = '60%'>" + "PMS/EMR Software Sales: " + "</td><td align = center><b>" + chkpms_emr.Checked + "</b></td></tr>"         //Where it is coming from ??
                body.Append("<tr><td width = '60%'>" + "Transcription Services: " + "</td><td align = center><b>" + chktranscription.Checked + "</b></td></tr>");
                body.Append("<tr><td width = '60%'>" + "Request Cost Analysis: " + "</td><td align = center><b>" + chkcost_anal.Checked + "</b></td></tr>");
                //New Items Added on 9/7/2010 by Nour/Kyle
                body.Append("<tr><td width = '60%'>" + "Patient Assessment (P.A.S.): " + "</td><td align = center><b>" + chkPatientAssessment_PAS.Checked + "</b></td></tr>");
                body.Append("<tr><td width = '60%'>" + "Custom Wellness Program: " + "</td><td align = center><b>" + chkCustomWellnessProgram.Checked + "</b></td></tr>");
                //Done New Items 9/7/2010
                //New Items Added on 9/15/2010 by Nour/Kyle
                body.Append("<tr><td width = '60%'>" + "MD Audit Shield – RAC: " + "</td><td align = center><b>" + chkMDAuditShield.Checked + "</b></td></tr>");
                body.Append("<tr><td width = '60%'>" + "CodeMAXX Services: " + "</td><td align = center><b>" + chkCodeMAXXServices.Checked + "</b></td></tr>");
                body.Append("<tr><td width = '60%'>" + "Physician Credentialing: " + "</td><td align = center><b>" + chkPhysicianCredentialing.Checked + "</b></td></tr></table>");

                message.Body = body.ToString();

                SmtpClient client = new SmtpClient();

                if (this.domain.ToLowerInvariant().Trim().EndsWith("claimtek.com"))
                {
                    client = new SmtpClient("localhost");
                }
                else
                {
                    client = new SmtpClient("relay-hosting.secureserver.net");
                }

                client.Send(message);
                successMessage.Visible = true;
                clearForm();
            }
            if (result == RecaptchaVerificationResult.IncorrectCaptchaSolution)
            {
                lblRecaptcha.Text = "Incorrect captcha response.";
            }
            else
            {
                lblRecaptcha.Text = "Some other problem with captcha.";
            }
        }
    }

}