<%@ Page Title="EMR Design" Language="C#" MasterPageFile="~/EMR/EMR.master" AutoEventWireup="true" CodeFile="Design.aspx.cs" Inherits="EMR_Design" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" runat="Server">
    <div class="page-header">
        <h3 class="page-heading"><small>Practice-Friendly Software Design... 
        </small></h3>
    </div>
    <p>
        Our EMR Software's design concentrates frequently
         accessed patient data in just a few screens: EMR Software 
        <b>Practice View</b> screen provides an up-to-the-minute
         overview of all office activity. At-a-glance tools include: 
    </p>
    <div>
        <table style="width:80%;">
            <tr>
                 <td><ul>
            <li>Calendar                                          </li>
            <li>ToDo's with visual status indicators              </li>
            <li>Patient Tracker with color coding                 </li>
            <li>Detailed message list with patient identifiers    </li>
            <li>Appointment schedule                              </li>
        </ul>
            </td>
                <td>
        <img src="/EMR/Images/PracticeView.jpg" alt="EMR Tools" class="img-responsive pull-right"></td>
       
                </tr>
            </table>
    </div>
    <hr />
    <h4>Patient Chart</h4>
    <p>
        The Patient Chart provides a comprehensive and logical view 
        of all data related to a specific patient. Static elements are
         on the left and events are listed by category in an "event tree" on the right.  
    </p>
    <div>
        <table style="width:80%;">
            <tr>
                
                <td>
        <b>Static Information:</b>
        <ul>
            <li>Demographics               </li>
            <li>Allergies                  </li>
            <li>Problem List               </li>
            <li>Other Sensitivities        </li>
            <li>Routine Meds               </li>
            <li>Previous Medical History   </li>
            <li>Referring Doctor           </li>
            <li>Family Medical History     </li>
            <li>Chart Note                 </li>
            <li>Social History             </li>
            <li>Insurance                  </li>
        </ul>
        <b>Events:</b>
        <ul>
            <li>Encounters                           </li>
            <li>Immunizations                        </li>
            <li>Labs                                 </li>
            <li>Imaging                              </li>
            <li>Medical Tests                        </li>
            <li>Flow Sheets                          </li>
            <li>Text Records                         </li>
            <li>Excuses/Notes                        </li>
            <li>Additional User-Definable Categories </li>
        </ul>
                    </td>
                <td>
        <img src="/EMR/Images/OfficeVisit.jpg" alt="EMR Software" class="img-responsive pull-right">
                    </td>
                </tr>
            </table>
    </div>
    <hr />
    <h4>Office Visit</h4>
    <p>Our EMR Software's Office Visit screen enables rapid and complete documentation of an entire office visit with little or no typing. Elements include:   </p>
    <div>
        <table style="width:80%;">
            <tr>
            <td>
        <b>Classic SOAP Format:</b>
        <ul>
            <li>(S) Subjectives                           </li>
            <li>(O) Objectives                            </li>
            <li>(A) Assessment                            </li>
            <li>(P) Plan                                  </li>
            <li>PopUp Text                                </li>
            <li>PopUp Text List                           </li>
            <li>(middle panel) is variable and corresponds to the OV<br /> component currently in use by the practitioner.
      </li>
        </ul>
        <b>OV Components:</b>
        <ul>
            <li>Chief Complaint          </li>
            <li>Review of Systems        </li>
            <li>Vitals                   </li>
            <li>Examination              </li>
            <li>Diagnoses                </li>
            <li>Prescriptions            </li>
            <li>Tests                    </li>
            <li>Procedures               </li>
            <li>Other Treatment          </li>
            <li>Follow-up                </li>
        </ul></td>
                <td>
        <img src="/EMR/Images/Capture-222.jpg" alt="EMR Office Visit" class="img-responsive pull-right">
                </td>
            </tr>
            </table>
    </div>
    <hr />
</asp:Content>

