<%@ Page Title="MD Audit Shield - RAC" Language="C#" MasterPageFile="~/Site.master" AutoEventWireup="true" CodeFile="MDAuditShield-RAC.aspx.cs" Inherits="MDAuditShield_RAC" %>

<asp:Content ID="Content4" ContentPlaceHolderID="MainContent" Runat="Server">
    <div class="page-header">
        <h3 class="page-heading">MD Audit Shield - RAC<br />
            <small>MD Audit Shield - Prepare for RAC Auditing!</small></h3>
    </div>

    <img class="img img-responsive img-rounded pull-right" style="padding-left: 10px;" title="MD Audit Shield - RAC" alt="MD Audit Shield - RAC" src="/Images/Audit-ShieldPageLogo.png" />
    <p>The federal government has recently implemented the "Recovery Audit Contract (RAC)," a new control process intended to weed out the large volume of fraudulent medical claims. To accomplish this, the government hired private auditing companies to perform audits on medical records and claims billing in all 50 states. Audits may cover any provider who bills fee-for-service Medicare, Medicaid, or commercial insurance programs. The audits will check for evidence of fraud by examining three common indicators of fraud: <b>1)</b> coding inconsistencies; <b>2)</b> documentation to support the medical necessity of the services provided; and <b>3)</b> overpayments or underpayments to providers. </p>
    
    <img class="img img-responsive img-rounded pull-right" style="padding-left: 10px;" title="MD Audit Shield - RAC" alt="MD Audit Shield - RAC" src="/Images/AuditShieldDr.jpg" />
    <p>This is a critical new procedure for all medical practices. If your practice's claims & records are audited and any of the three inconsistencies are found, you will be required to pay back not only the overpayment but also interest. In addition, appeals have not been successful. And the auditing companies will continue to audit your practice every 45 days until they find no further evidence of fraud.</p>

    <p>Reports estimate that the RAC program has already identified more than $1 billion in overpayments in just a few of the 50 states.</p>

    <p class="no-margin">Why take a risk in your practice? Begin using our <b>MD Audit Shield</b> services to eliminate the chances of an audit proving inconsistencies in your billing. While nothing will keep the government from auditing your practice, our <b>MD Audit Shield</b> service will at least protect your practice in several ways. <b>MD Audit Shield</b> takes the following steps to ensure your compliance:</p>
    <ul class="list-fix">
        <li>It reviews 50 records at random from your billing to check if any improper coding and non-compliance issues with Medicare/Medicaid appear.</li>
        <li>It specifies what corrective actions are needed to comply with codes.</li>
        <li>It performs any necessary changes to put you in compliance.</li>
        <li>It stands behind you with assistance in the event you are audited.</li>
    </ul>
    <p>Please <a href="/Contact-Us">contact us</a> today to prepare for RAC auditing. Our services are professional and affordable!</p>
</asp:Content>